/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Scrollbar;

public class Spiro
extends Applet {
    private int R = 99;
    private int r = 3;
    private int O = 100;
    private int I;
    private int degreeI;
    private boolean movingCircleOut = false;
    Scrollbar sliderR;
    Scrollbar sliderr;
    Scrollbar sliderO;
    Scrollbar sliderI;
    String sliderTextR = "Fixed circle radius (1 - 100): ";
    String sliderTextr = "Moving circle radius (1 - 100): ";
    String sliderTextO = "Moving circle offset (0 - 100): ";
    String sliderTextC = "Moving circle: ";
    String sliderTextI = "Revolutions in radians: ";
    Label sliderLabelR;
    Label sliderLabelr;
    Label sliderLabelO;
    Label labelColor;
    Label sliderLabelC;
    Label sliderLabelI;
    Label titleLabel;
    Panel fields;
    Scrollbar redSlider;
    Scrollbar blueSlider;
    Scrollbar greenSlider;
    Label redLabel;
    Label greenLabel;
    Label blueLabel;
    private int redBits = 90;
    private int greenBits = 246;
    private int blueBits = 255;
    String colorMode = "single";
    String sliderTextRed = "Red (0 - 255): ";
    String sliderTextGreen = "Green (0 - 255): ";
    String sliderTextBlue = "Blue (0 - 255): ";
    Panel colorPanel;
    Panel buttonPanel;
    CheckboxGroup CircleInOutGroup;
    Checkbox insideCheckbox;
    Checkbox outsideCheckbox;
    Checkbox singleColorCheckbox;
    Checkbox multiColorCheckbox;
    Checkbox randomColorCheckbox;
    CheckboxGroup LinePointGroup;
    Checkbox lineCheckbox;
    Checkbox pointCheckbox;
    Checkbox soundCheckbox;
    Checkbox bgCheckbox;
    int appletHeight = 400;
    int appletWidth = 680;
    Font font;
    Panel controlPanel;
    Panel optionPanelColor;
    Panel optionPanel0;
    Panel optionPanel1;
    Panel optionPanel2;
    String audioScroll = "bell.au";
    String audioButton = "chirp.au";
    Button okButton;

    public void getParams() {
        if (this.getParameter("R") != null) {
            this.R = new Integer(new String(this.getParameter("R")));
            if (this.R < 1) {
                this.R = 1;
            } else if (this.R > 100) {
                this.R = 100;
            }
        }
        if (this.getParameter("smallr") != null) {
            this.r = new Integer(new String(this.getParameter("smallr")));
            if (this.r < 1) {
                this.r = 1;
            } else if (this.r > 100) {
                this.r = 100;
            }
        }
        this.I = this.revolutions(this.R, this.r);
        if (this.getParameter("O") != null) {
            this.O = new Integer(new String(this.getParameter("O")));
            if (this.O < 1) {
                this.O = 1;
            } else if (this.O > 100) {
                this.O = 100;
            }
        }
        if (this.getParameter("movingCircleOut") != null) {
            this.movingCircleOut = new Boolean(new String(this.getParameter("movingCircleOut")));
        }
        if (this.getParameter("redBits") != null) {
            this.redBits = new Integer(new String(this.getParameter("redBits")));
            if (this.redBits < 0) {
                this.redBits = 0;
            } else if (this.redBits > 255) {
                this.redBits = 255;
            }
        }
        if (this.getParameter("greenBits") != null) {
            this.greenBits = new Integer(new String(this.getParameter("greenBits")));
            if (this.greenBits < 0) {
                this.greenBits = 0;
            } else if (this.greenBits > 255) {
                this.greenBits = 255;
            }
        }
        if (this.getParameter("blueBits") != null) {
            this.blueBits = new Integer(new String(this.getParameter("blueBits")));
            if (this.blueBits < 0) {
                this.blueBits = 0;
            } else if (this.blueBits > 255) {
                this.blueBits = 255;
            }
        }
        if (this.getParameter("colorMode") != null) {
            this.colorMode = new String(this.getParameter("colorMode"));
        }
        if (this.getParameter("height") != null) {
            this.appletHeight = new Integer(new String(this.getParameter("height")));
            if (this.appletHeight < 1) {
                this.appletHeight = 400;
            }
        }
        if (this.getParameter("width") != null) {
            this.appletWidth = new Integer(new String(this.getParameter("width")));
            if (this.appletWidth < 1) {
                this.appletWidth = 680;
            }
        }
    }

    public void init() {
        this.getParams();
        this.showStatus("Spirograph by Anu Garg (gargATwordsmith.org) http://wordsmith.org/anu");
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setLayout(new BorderLayout());
        this.controlPanel = new Panel();
        this.controlPanel.setLayout(new GridLayout(27, 1));
        this.add("East", this.controlPanel);
        this.titleLabel = new Label("S  P  I  R  O  G  R  A  P  H", 1);
        this.font = new Font("Helvetica", 1, 13);
        this.titleLabel.setFont(this.font);
        this.titleLabel.setBackground(Color.gray);
        this.titleLabel.setForeground(Color.white);
        this.controlPanel.add(this.titleLabel);
        this.controlPanel.add(new Label(" "));
        this.sliderLabelR = new Label(this.sliderTextR + Integer.toString(this.R));
        this.controlPanel.add(this.sliderLabelR);
        this.sliderR = new Scrollbar(0, this.R, 1, 1, 101);
        this.controlPanel.add(this.sliderR);
        this.sliderLabelr = new Label(this.sliderTextr + Integer.toString(this.r));
        this.controlPanel.add(this.sliderLabelr);
        this.sliderr = new Scrollbar(0, this.r, 1, 1, 101);
        this.controlPanel.add(this.sliderr);
        this.sliderLabelO = new Label(this.sliderTextO + Integer.toString(this.O));
        this.controlPanel.add(this.sliderLabelO);
        this.sliderO = new Scrollbar(0, this.O, 1, 0, 101);
        this.controlPanel.add(this.sliderO);
        this.controlPanel.add(new Label(" "));
        this.sliderLabelC = new Label(this.sliderTextC);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.insideCheckbox = new Checkbox("inside", checkboxGroup, !this.movingCircleOut);
        this.outsideCheckbox = new Checkbox("outside", checkboxGroup, this.movingCircleOut);
        this.optionPanel0 = new Panel();
        this.optionPanel0.setLayout(new GridLayout(1, 3));
        this.optionPanel0.add(this.sliderLabelC);
        this.optionPanel0.add(this.insideCheckbox);
        this.optionPanel0.add(this.outsideCheckbox);
        this.controlPanel.add("North", this.optionPanel0);
        this.controlPanel.add(new Label(" "));
        this.redLabel = new Label(this.sliderTextRed + Integer.toString(this.redBits));
        this.controlPanel.add(this.redLabel);
        this.redSlider = new Scrollbar(0, this.redBits, 1, 0, 256);
        this.controlPanel.add(this.redSlider);
        this.greenLabel = new Label(this.sliderTextGreen + Integer.toString(this.greenBits));
        this.controlPanel.add(this.greenLabel);
        this.greenSlider = new Scrollbar(0, this.greenBits, 1, 0, 256);
        this.controlPanel.add(this.greenSlider);
        this.blueLabel = new Label(this.sliderTextBlue + Integer.toString(this.blueBits));
        this.controlPanel.add(this.blueLabel);
        this.blueSlider = new Scrollbar(0, this.blueBits, 1, 0, 256);
        this.controlPanel.add(this.blueSlider);
        this.controlPanel.add(new Label(" "));
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        this.singleColorCheckbox = new Checkbox("single", checkboxGroup2, this.colorMode.equals("single"));
        this.multiColorCheckbox = new Checkbox("multi", checkboxGroup2, this.colorMode.equals("multi"));
        this.randomColorCheckbox = new Checkbox("random", checkboxGroup2, this.colorMode.equals("random"));
        this.optionPanelColor = new Panel();
        this.optionPanelColor.setLayout(new GridLayout(1, 4));
        this.labelColor = new Label("Color: ");
        this.optionPanelColor.add(this.labelColor);
        this.optionPanelColor.add(this.singleColorCheckbox);
        this.optionPanelColor.add(this.multiColorCheckbox);
        this.optionPanelColor.add(this.randomColorCheckbox);
        this.controlPanel.add("North", this.optionPanelColor);
        this.controlPanel.add(new Label(" "));
        this.sliderLabelI = new Label(this.sliderTextI + Integer.toString(this.I));
        this.controlPanel.add(this.sliderLabelI);
        this.sliderI = new Scrollbar(0, this.I, 1, 0, 400);
        this.controlPanel.add(this.sliderI);
        this.controlPanel.add(new Label(" "));
        this.optionPanel1 = new Panel();
        this.optionPanel1.setLayout(new GridLayout(1, 2));
        this.optionPanel2 = new Panel();
        this.optionPanel2.setLayout(new GridLayout(1, 2));
        CheckboxGroup checkboxGroup3 = new CheckboxGroup();
        this.lineCheckbox = new Checkbox("line", checkboxGroup3, true);
        this.pointCheckbox = new Checkbox("point", checkboxGroup3, false);
        this.soundCheckbox = new Checkbox("sound effects", true);
        this.bgCheckbox = new Checkbox("dark canvas", true);
        this.optionPanel1.add(this.lineCheckbox);
        this.optionPanel1.add(this.soundCheckbox);
        this.optionPanel2.add(this.pointCheckbox);
        this.optionPanel2.add(this.bgCheckbox);
        this.controlPanel.add("North", this.optionPanel1);
        this.controlPanel.add("North", this.optionPanel2);
        this.controlPanel.add(new Label(" "));
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new GridLayout(1, 2, 4, 0));
        this.buttonPanel.add(new Button("Random"));
        this.buttonPanel.add(new Button("About"));
        this.controlPanel.add("North", this.buttonPanel);
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Scrollbar) {
            if (this.soundCheckbox.getState()) {
                this.play(this.getCodeBase(), this.audioScroll);
            }
            int n = ((Scrollbar)event.target).getValue();
            if (event.target == this.sliderR) {
                this.sliderLabelR.setText(this.sliderTextR + Integer.toString(n));
                this.R = n;
                this.I = this.revolutions(this.R, this.r);
                this.sliderLabelI.setText(this.sliderTextI + Integer.toString(this.I));
                this.sliderI.setValue(this.I);
            } else if (event.target == this.sliderr) {
                this.sliderLabelr.setText(this.sliderTextr + Integer.toString(n));
                this.r = n;
                if (this.r == 0) {
                    ++this.r;
                }
                this.I = this.revolutions(this.R, this.r);
                this.sliderLabelI.setText(this.sliderTextI + Integer.toString(this.I));
                this.sliderI.setValue(this.I);
            } else if (event.target == this.sliderO) {
                this.sliderLabelO.setText(this.sliderTextO + Integer.toString(n));
                this.O = n;
            } else if (event.target == this.redSlider) {
                this.redLabel.setText(this.sliderTextRed + Integer.toString(n));
                this.redBits = n;
            } else if (event.target == this.greenSlider) {
                this.greenLabel.setText(this.sliderTextGreen + Integer.toString(n));
                this.greenBits = n;
            } else if (event.target == this.blueSlider) {
                this.blueLabel.setText(this.sliderTextBlue + Integer.toString(n));
                this.blueBits = n;
            } else if (event.target == this.sliderI) {
                this.sliderLabelI.setText(this.sliderTextI + Integer.toString(n));
                this.I = n;
            }
            this.repaint();
            return true;
        }
        return super.handleEvent(event);
    }

    int revolutions(int n, int n2) {
        return n2 / this.gcd(n, n2) * 7;
    }

    public boolean action(Event event, Object object) {
        if ("Random".equals(object)) {
            if (this.soundCheckbox.getState()) {
                this.play(this.getCodeBase(), this.audioButton);
            }
            this.R = (int)(Math.random() * 100.0 + 1.0);
            this.r = (int)(Math.random() * 100.0 + 1.0);
            if (this.r == 0) {
                ++this.r;
            }
            this.O = (int)(Math.random() * 100.0 + 1.0);
            this.sliderLabelR.setText(this.sliderTextR + Integer.toString(this.R));
            this.sliderLabelr.setText(this.sliderTextr + Integer.toString(this.r));
            this.sliderLabelO.setText(this.sliderTextO + Integer.toString(this.O));
            this.sliderR.setValue(this.R);
            this.sliderr.setValue(this.r);
            this.sliderO.setValue(this.O);
            this.I = this.revolutions(this.R, this.r);
            this.sliderLabelI.setText(this.sliderTextI + Integer.toString(this.I));
            this.sliderI.setValue(this.I);
            this.redBits = (int)(Math.random() * 255.0);
            this.blueBits = (int)(Math.random() * 255.0);
            this.greenBits = (int)(Math.random() * 255.0);
            this.redLabel.setText(this.sliderTextRed + Integer.toString(this.redBits));
            this.greenLabel.setText(this.sliderTextGreen + Integer.toString(this.greenBits));
            this.blueLabel.setText(this.sliderTextBlue + Integer.toString(this.blueBits));
            this.redSlider.setValue(this.redBits);
            this.greenSlider.setValue(this.greenBits);
            this.blueSlider.setValue(this.blueBits);
            this.repaint();
            return true;
        }
        if ("About".equals(object)) {
            AboutDialog aboutDialog = new AboutDialog(this);
            aboutDialog.pack();
            aboutDialog.show();
            return true;
        }
        if (event.target == this.lineCheckbox || event.target == this.pointCheckbox || event.target == this.bgCheckbox || event.target == this.singleColorCheckbox || event.target == this.multiColorCheckbox || event.target == this.randomColorCheckbox || event.target == this.insideCheckbox || event.target == this.outsideCheckbox) {
            this.repaint();
            return true;
        }
        return true;
    }

    public int gcd(int n, int n2) {
        if (n % n2 == 0) {
            return n2;
        }
        return this.gcd(n2, n % n2);
    }

    public void paint(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.004 * Math.sqrt(this.r);
        int n5 = this.appletHeight / 2;
        if (this.bgCheckbox.getState()) {
            graphics.fillRoundRect(0, 0, this.appletHeight, this.appletHeight, 25, 25);
        } else {
            graphics.drawRoundRect(0, 0, this.appletHeight, this.appletHeight - 1, 25, 25);
        }
        graphics.clipRect(0, 0, this.appletHeight - 1, this.appletHeight - 1);
        double d2 = this.R + this.r;
        double d3 = this.R - this.r;
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        for (double d4 = 0.0; d4 <= (double)this.I; d4 += d) {
            double d5;
            n3 = n;
            n4 = n2;
            if (this.multiColorCheckbox.getState()) {
                this.redBits = 200;
                int n9 = (int)(Math.random() * 3.0);
                switch (n9) {
                    case 0: {
                        if (this.redBits < 1) {
                            n6 = 1;
                        }
                        if (this.redBits > 254) {
                            n6 = -1;
                        }
                        this.redBits += n6;
                    }
                    case 1: {
                        if (this.greenBits < 1) {
                            n7 = 1;
                        }
                        if (this.greenBits > 254) {
                            n7 = -1;
                        }
                        this.greenBits += n7;
                    }
                    case 2: {
                        if (this.blueBits < 1) {
                            n8 = 1;
                        }
                        if (this.blueBits > 254) {
                            n8 = -1;
                        }
                        this.blueBits += n8;
                    }
                }
            } else if (this.randomColorCheckbox.getState()) {
                this.redBits = (int)(Math.random() * 255.0);
                this.blueBits = (int)(Math.random() * 255.0);
                this.greenBits = (int)(Math.random() * 255.0);
            }
            graphics.setColor(new Color(this.redBits, this.greenBits, this.blueBits));
            if (this.outsideCheckbox.getState()) {
                d5 = d2 * d4 / (double)this.r;
                n = (int)(d2 * Math.cos(d4) - (double)this.O * Math.cos(d5) + (double)n5);
                n2 = (int)(d2 * Math.sin(d4) - (double)this.O * Math.sin(d5) + (double)n5);
            } else {
                d5 = d3 * d4 / (double)this.r;
                n = (int)(d3 * Math.cos(d4) + (double)this.O * Math.cos(d5) + (double)n5);
                n2 = (int)(d3 * Math.sin(d4) - (double)this.O * Math.sin(d5) + (double)n5);
            }
            if (this.lineCheckbox.getState()) {
                if (!(d4 > 0.0)) continue;
                graphics.drawLine(n3, n4, n, n2);
                continue;
            }
            graphics.drawLine(n, n2, n, n2);
        }
    }
}

